
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    poly        f;
    string      inString;
    char        *xString;
    int         len;
    bf          x, z;
    
polyIn:
    cout << "poly: ";
    getline(cin, inString);
    cout << endl;
    
    len = strlen(inString.c_str());
    xString = (char*)malloc((len+1)*sizeof(char));
    strcpy(xString, inString.c_str());
    
    if(!polyConvFromxString(f, xString))
    {
        cout << "bad input" << endl;
        goto polyIn;
    }
  
again:
    cout << "x: ";
    cin >> x;
    
    z = polyEval(f, x);
    cout << "poly(x) = " << z << endl << endl;
    
    goto again;
    
    return 0;
}


